#                                               -*- Python -*-
#
#  __init__.py
#
#  (C) Copyright 2005-2012 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2009-01-28 14:45:54 +0100 (mer, 28 jan 2009) $
#  Id:      $Id: Makefile.am 1087 2009-01-28 13:45:54Z dutka $
#

"""
    Open TURNS --- The uncertainty engineering software
    ===================================================

    Documentation is available online at http://www.openturns.org.

    Contents
    --------
      Open TURNS imports all the functions from the OT namespace.

    Available subpackages
    ---------------------
      common                                --- Utility classes
      wrapper                               --- Wrapping utilities
      typ                                   --- Internal data types
      statistics                            --- Statistical classes
      graph                                 --- Graphical output
      func                                  --- Function primitives
      diff                                  --- Differential algorithms
      optim                                 --- Optimization routines
      solver                                --- Solvers
      algo                                  --- Approximation algorithms
      base                                  --- Deterministic meta-package

      model_copula                          --- Copulas
      randomvector                          --- Random vectors
      dist                                  --- Probabilistic distributions
      model_process                         --- Stochastic processes
      experiment                            --- Design experiments
      orthogonalbasis                       --- Polynomial primitives
      metamodel                             --- Meta-modelling
      transformation                        --- Iso-probabilictic and process transformations
      analytical                            --- Analytical uncertainty propagation algorithms
      simulation                            --- Simulation uncertainty propagation algorithms
      stattests                             --- Statistical tests
      uncertainty                           --- Probabilistic meta-package

    Utility tools
    -------------

      __version__                           --- Open TURNS version string

    Environment variables
    ---------------------

      OPENTURNS_HOME                        --- Custom installation path
      OPENTURNS_MODULE_PATH                 --- Submodule path
      OPENTURNS_CONFIG_PATH                 --- Path to configuration file
      OPENTURNS_WRAPPER_PATH                --- Path to custom wrappers
      OPENTURNS_LOG_SEVERITY                --- Log severity flag, for example "ALL"
      OPENTURNS_PYTHON_SILENT               --- Disables welcoming message if set.

:
"""

# Reset the default Crtl-C behavior
import signal
import sys
try:
    signal.signal(signal.SIGINT, signal.SIG_DFL)
except ValueError:
    print>>  sys.stderr, "Failed to setup thread-interrupt handler. This is usually not critical"

from common import *
from wrapper import *
from typ import *
from statistics import *
from graph import *
from func import *
from diff import *
from optim import *
from solver import *
from algo import *
from base import *

from model_copula import *
from randomvector import *
from dist import *
from model_process import *
from experiment import *
from orthogonalbasis import *
from metamodel import *
from transformation import *
from analytical import *
from simulation import *
from stattests import *
from uncertainty import *

import os
import platform

# define the version
__version__ = PlatformInfo.GetVersion()

# This code prints the version number when the module is imported
if not ( ( os.environ.has_key( 'OPENTURNS_PYTHON_SILENT' ) and ( len(os.environ[ 'OPENTURNS_PYTHON_SILENT' ]) != 0 ) ) or ( "--silent" in sys.argv ) ):
  sys.stderr.write( "Welcome to OpenTURNS version %s\n" % __version__ )

# This code sets the sys.path (through site module) to point to the module standard dirs
dirs = os.getenv("OPENTURNS_MODULE_PATH", None)
if dirs:
    import string
    if(platform.system() != "Windows"):
        path_separator = ":"
    else:
        path_separator = ";"
    dirlist = string.split(dirs, path_separator)
else:
    dirlist = list()
dirlist.append( "%s/openturns/lib/openturns/module" % os.getenv("HOME") )
dirlist.append( Path.GetModuleDirectory() )
dirlist.append( Path.GetInstallationDirectory() )

import site
otpaths = set()
for d in dirlist:
    if(platform.system() != "Windows"):
        python_suffix = "/lib/python%d.%d/site-packages" % ( sys.version_info[0], sys.version_info[1] )
    else:
        python_suffix = "/lib/python%d%d/site-packages" % ( sys.version_info[0], sys.version_info[1] )
    site.addsitedir( d + python_suffix, otpaths )
#print "known_paths =", otpaths

def PRINT(obj):
  return repr(obj)


