//                                               -*- C++ -*-
/**
 *  @file  t_Event_std.cxx
 *  @brief The test file of Event class
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_Event_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Event.hxx"
#include "RandomVector.hxx"
#include "CompositeRandomVector.hxx"
#include "Less.hxx"
#include "NumericalMathFunction.hxx"
#include "Domain.hxx"
#include "Interval.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {

    /* We create a numerical point of dimension 1 */
    NumericalPoint point(4);
    const NumericalPoint & ref_point(point);

    point[0] = 101;
    point[1] = 202;
    point[2] = 303;
    point[3] = 404;

    fullprint << "point = " << ref_point << std::endl;



    /* We create a 'constant' RandomVector from the NumericalPoint */
    RandomVector vect(point);
    fullprint << "vect=" << vect << std::endl;

    /* Check standard methods of class RandomVector */
    fullprint << "vect dimension=" << vect.getDimension() << std::endl;
    fullprint << "vect realization (first )=" << vect.getRealization() << std::endl;
    fullprint << "vect sample =" << vect.getNumericalSample(5) << std::endl;

    /* We create a numerical math function */
    NumericalMathFunction myFunction("poutre");

    /* We create a composite random vector */
    RandomVector output(myFunction, vect);

    /* We create an Event from this RandomVector */
    Event myEvent(output, Less(), 50);
    fullprint << "myEvent=" << myEvent << std::endl;

    /* We compute one realization of the event */
    fullprint << "myEvent realization=" << myEvent.getRealization() << std::endl;
    fullprint << "myEvent antecedent realization=" << myEvent.getImplementation()->getAntecedent()->getRealization() << std::endl;

    /* We compute a sample of the event */
    fullprint << "myEvent sample=" << myEvent.getNumericalSample(10) << std::endl;




    /* We create an Event using a domain implementation */
    Domain domain = Interval(1); // Domain is [0, 1]

    Event myDomainEvent(output, domain);
    fullprint << "myDomainEvent=" << myDomainEvent << std::endl;

    /* We compute one realization of the event */
    fullprint << "myDomainEvent realization=" << myDomainEvent.getRealization() << std::endl;
    fullprint << "myDomainEvent antecedent realization=" << myDomainEvent.getImplementation()->getAntecedent()->getRealization() << std::endl;

    /* We compute a sample of the event */
    fullprint << "myDomainEvent sample=" << myDomainEvent.getNumericalSample(10) << std::endl;


    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("myEvent", myEvent);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    Event event;
    myStudy2.fillObject("myEvent", event);
    fullprint << "loaded Event=" << event << std::endl;

    Study myStudy3;
    myStudy3.setStorageManager(XMLStorageManager("testStudyEvent.ot"));
    myStudy3.add("myDomainEvent", myDomainEvent);
    myStudy3.save();

    Study myStudy4;
    myStudy4.setStorageManager(XMLStorageManager("testStudyEvent.ot"));
    myStudy4.load();
    Event eventDomain;
    myStudy4.fillObject("myDomainEvent", eventDomain);
    fullprint << "loaded DomainEvent=" << eventDomain << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
