//                                               -*- C++ -*-
/**
 *  @file  NonEllipticalDistribution.hxx
 *  @brief Abstract top-level class for non elliptical distributions
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: NonEllipticalDistribution.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_NONELLIPTICALDISTRIBUTION_HXX
#define OPENTURNS_NONELLIPTICALDISTRIBUTION_HXX

#include "ContinuousDistribution.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class NonEllipticalDistribution
 *
 * All traditionnal distribution inherits from this class.
 * Classes derived from NonEllipticalDistribution are known by themselves,
 * without being reconstructed or built in any way.
 */
class NonEllipticalDistribution
  : public ContinuousDistribution
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit NonEllipticalDistribution(const String & name = DefaultName);

  /** Virtual constructor */
  virtual NonEllipticalDistribution * clone() const;

  /** String converter */
  String __repr__() const;


protected:


private:


}; /* class NonEllipticalDistribution */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_NONELLIPTICALDISTRIBUTION_HXX */
