//                                               -*- C++ -*-
/**
 *  @file  Event.hxx
 *  @brief This class specializes the concept of RandomVector by constructing a Bernoulli
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: Event.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_EVENT_HXX
#define OPENTURNS_EVENT_HXX

#include "RandomVector.hxx"
#include "Pointer.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class Event
 *
 * The class that implements all random vectors
 */
class Event
  : public RandomVector
{
  CLASSNAME;

public:


  /** for save/load mecanism */
  Event();

  /** Constructor from RandomVector */
  Event(const RandomVector & antecedent,
        const ComparisonOperator & op,
        const NumericalScalar threshold,
        const String & name = DefaultName);

  /** Constructor from RandomVector */
  Event(const RandomVector & antecedent,
        const Domain & domain,
        const String & name = DefaultName);

  /** Constructor from RandomVector */
  Event(const Process &  process,
        const Domain & domain,
        const String & name = DefaultName);

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

private:

}; /* class Event */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_EVENT_HXX */
