//                                               -*- C++ -*-
/**
 *  @file  Copula.cxx
 *  @brief Abstract top-level class for all copulas
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: Copula.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "Copula.hxx"
#include "IndependentCopula.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(Copula);


/* Default constructor */
Copula::Copula()
  : Distribution(IndependentCopula(1))
{
  // Nothing to do
}

/* Constructor from distribution */
Copula::Copula(const Distribution & distribution)
  : Distribution(distribution)
{
  // Nothing to do
}

/* Constructor from implementation */
Copula::Copula(const DistributionImplementation & implementation,
               const String & name)
  : Distribution(implementation, name)
{
  // Nothing to do
}

/* Constructor from implementation */
Copula::Copula(const Implementation & p_implementation,
               const String & name)
  : Distribution(p_implementation, name)
{
  // Nothing to do
}

/* Constructor from implementation */
Copula::Copula(DistributionImplementation * p_implementation,
               const String & name)
  : Distribution(p_implementation, name)
{
  // Nothing to do
}

/* String converter */
String Copula::__repr__() const
{
  return Distribution::__repr__();
}

/* String converter */
String Copula::__str__(const String & offset) const
{
  return Distribution::__str__(offset);
}


END_NAMESPACE_OPENTURNS
