//                                               -*- C++ -*-
/**
 *  @file  TruncatedNormalFactory.hxx
 *  @brief Factory for TruncatedNormal distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: TruncatedNormalFactory.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_TRUNCATEDNORMALFACTORY_HXX
#define OPENTURNS_TRUNCATEDNORMALFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "TruncatedNormal.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class TruncatedNormalFactory
 */
class TruncatedNormalFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  TruncatedNormalFactory();

  /** Virtual constructor */
  TruncatedNormalFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  TruncatedNormal * build(const NumericalSample & sample) const;
  TruncatedNormal * build(const NumericalPointCollection & parameters) const;
  TruncatedNormal * build() const;


}; /* class TruncatedNormalFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_TRUNCATEDNORMALFACTORY_HXX */
