//                                               -*- C++ -*-
/**
 *  @file  RandomDirection.hxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: RandomDirection.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_RANDOMDIRECTION_HXX
#define OPENTURNS_RANDOMDIRECTION_HXX

#include "SamplingStrategyImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class RandomDirection
 */

class RandomDirection :
  public SamplingStrategyImplementation
{

  CLASSNAME;

public:


  /** Default constructor */
  explicit RandomDirection();

  /** Constructor with parameters */
  explicit RandomDirection(const UnsignedLong dimension);


  /** Virtual constructor */
  virtual RandomDirection * clone() const;

  /** Generate a set of directions */
  NumericalSample generate() const;

  /** String converter */
  String __repr__() const;

} ; /* class RandomDirection */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_RANDOMDIRECTION_HXX */
