//                                               -*- C++ -*-
/**
 *  @file  ExponentialRBF.hxx
 *  @brief Implementation of the Exponential RBF kernel
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: ExponentialRBF.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_EXPONENTIALRBF_HXX
#define OPENTURNS_EXPONENTIALRBF_HXX

#include "SVMKernelImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class ExponentialRBF
 *
 * Implementation of the Exponential RBF kernel
 */



class ExponentialRBF
  : public SVMKernelImplementation
{
  CLASSNAME;
public:


  /** Constructor with parameters */
  ExponentialRBF(const NumericalScalar sigma = 1.0);

  /** Virtual constructor */
  virtual ExponentialRBF * clone() const;

  /** String converter */
  virtual String __repr__() const;

  /** Sigma parameter accessor */
  virtual NumericalScalar getSigma() const;
  virtual void setSigma(NumericalScalar sigma);

  /** Accessor to the parameter used for cross-validation */
  virtual NumericalScalar getParameter() const;
  virtual void setParameter(NumericalScalar value);

  /** Parameters value and description accessor */
  virtual NumericalPointWithDescription getParameters() const;
  virtual void setParameters(const NumericalPointWithDescription & parameters);

  /** Operator () */
  virtual NumericalScalar operator() (const NumericalPoint & x1, const NumericalPoint & x2) const;

  /** Partial gradient */
  virtual NumericalPoint partialGradient(const NumericalPoint & x1, const NumericalPoint & x2) const;

  /** Partial hessian */
  virtual SymmetricMatrix partialHessian(const NumericalPoint & x1, const NumericalPoint & x2) const;

protected:
  NumericalScalar sigma_;

private:

} ; /* class ExponentialRBF */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_EXPONENTIALRBF_HXX */
