//                                               -*- C++ -*-
/**
 *  @file  FilteringWindowsImplementation.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */
#include "FilteringWindows.hxx"
#include "PersistentObjectFactory.hxx"
#include "Hamming.hxx"

BEGIN_NAMESPACE_OPENTURNS

CLASSNAMEINIT(FilteringWindows);

/* Constructor with parameters */
FilteringWindows::FilteringWindows()
  : TypedInterfaceObject<FilteringWindowsImplementation>(new Hamming())
{
  // Nothing to do
}

/* Parameters constructor */
FilteringWindows::FilteringWindows(const FilteringWindowsImplementation & implementation,
                                   const String & name)
  : TypedInterfaceObject<FilteringWindowsImplementation>(implementation.clone())
{
  getImplementation()->setName(name);
}

/* Constructor from implementation */
FilteringWindows::FilteringWindows(const Implementation & p_implementation,
                                   const String & name)
  : TypedInterfaceObject<FilteringWindowsImplementation>(p_implementation)
{
  getImplementation()->setName(name);
}

/* Constructor from implementation pointer */
FilteringWindows::FilteringWindows(FilteringWindowsImplementation * p_implementation,
                                   const String & name)
  : TypedInterfaceObject<FilteringWindowsImplementation>(p_implementation)
{
  getImplementation()->setName(name);
}

/* functor - evaluation of filter using () */
NumericalScalar FilteringWindows::operator()(const NumericalScalar t) const
{
  return getImplementation()->operator()(t);
}

/* String converter */
String FilteringWindows::__repr__() const
{
  OSS oss;
  oss << "class=" << FilteringWindows::GetClassName()
      << " implementation=" << getImplementation()->__repr__();
  return oss;
}

/* String converter */
String FilteringWindows::__str__(const String & offset) const
{
  OSS oss;
  oss << "class=" << FilteringWindows::GetClassName()
      << " implementation=" << getImplementation()->__str__(offset);
  return oss;
}

END_NAMESPACE_OPENTURNS
