//                                               -*- C++ -*-
/**
 *  @file  ExponentialCauchy.hxx
 *  @brief This class is enables to build an exponential covariance
 *  model, a second order model's implementation
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: ExponentialCauchy.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_EXPONENTIALCAUCHYMODEL_HXX
#define OPENTURNS_EXPONENTIALCAUCHYMODEL_HXX

#include "PersistentObject.hxx"
#include "SecondOrderModelImplementation.hxx"
#include "NumericalPoint.hxx"
#include "CorrelationMatrix.hxx"

BEGIN_NAMESPACE_OPENTURNS


class RegularGrid;

/**
 * @class ExponentialCauchy
 */

class ExponentialCauchy
  : public SecondOrderModelImplementation
{

  CLASSNAME;

public:


  /** Default constructor without parameters */
  ExponentialCauchy(const String & name = DefaultName);

  /** Standard constructor with amplitude and scale parameters parameters */
  ExponentialCauchy(const NumericalPoint & amplitude,
                    const NumericalPoint & scale,
                    const String & name = DefaultName);

  /** Standard constructor with amplitude, scale and spatial correlation parameters parameters */
  ExponentialCauchy(const NumericalPoint & amplitude,
                    const NumericalPoint & scale,
                    const CorrelationMatrix & spatialCorrelation,
                    const String & name = DefaultName);

  /** Standard constructor with scale and spatial covariance parameters parameters */
  ExponentialCauchy(const NumericalPoint & scale,
                    const CovarianceMatrix & spatialCovariance,
                    const String & name = DefaultName);

  /** Virtual copy constructor */
  ExponentialCauchy * clone() const;

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

  /** Amplitude accessor */
  NumericalPoint getAmplitude() const;

  /** Scale accessor */
  NumericalPoint getScale() const;

  /** Spatial correlation accessor */
  CorrelationMatrix getSpatialCorrelation() const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

private :

} ; /* class SecondOrderModelImplementation */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_EXPONENTIALCAUCHYMODEL_HXX */
