#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :
    dim = 5
    meanPoint = NumericalPoint(dim, 0.0)
    sigma = NumericalPoint(dim, 5.0)
    R = CorrelationMatrix(dim)

    distribution = Normal(meanPoint, sigma, R)

    # Instanciate another distribution object
    for i in range(1, dim):
        R[i, i - 1] = -0.25

    distribution2 = Normal(meanPoint, sigma, R)

    # Test for sampling
    size = 1000
    sample = distribution.getNumericalSample( size )
    # Create an empty graph
    myGraph = Graph("Pairs", " ", " ", True, "topright")

    # Create the first cloud
    myPairs = Pairs(sample, "Pairs example", sample.getDescription(), "green", "bullet")

    # Then, draw it
    myGraph.add(Drawable(myPairs))
    myGraph.draw("Graph_Pairs_OT")

    # Check that the correct files have been generated by computing their checksum
    print "bitmap=", myGraph.getBitmap()
    print "postscript=", myGraph.getPostscript()
    
except :
    import sys
    print "t_Pairs_std.py", sys.exc_type, sys.exc_value


