#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    distribution = Dirichlet(NumericalPoint([0.2, 0.3, 0.4, 0.5]))
    size = 10000
    sample = distribution.getNumericalSample(size)
    factory = DirichletFactory()
    estimatedDistribution = factory.build(sample)
    print "distribution=", repr(distribution)
    print "Estimated distribution=", repr(estimatedDistribution)

except :
    import sys
    print "t_DirichletFactory.py", sys.exc_type, sys.exc_value
