# -*- coding: utf-8 -*-
#                                               -*- Python -*-
#
# @file  Viewer.py
# @brief The viewer of drawing
#
# (C) Copyright 2005-2011 EDF-EADS-Phimeca
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# @author: $LastChangedBy: schueller $
# @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
# Id:      $Id: viewer.py 1866 2011-04-11 10:32:27Z schueller $
#

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from imageviewer import *
from controlwindow import *

def ViewImage(*images):
    app = QApplication([])
    controlWin = ControlWindow()
    count = 0

    for img in images[:]:
        imageWindow = ImageViewer(img, 'OpenTURNS Display [%u]' % count)
        imageWindow.show()
        controlWin.addImageWindow(imageWindow)
        count = count + 1

    controlWin.show()

    app.exec_()

def WaitForViewer(number):
    pass

def StopViewer():
    pass
