// SWIG file Basis.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (Mon, 09 Nov 2009) $
// Id : $Id: Basis.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "Basis.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Func::Basis>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Func::Basis
  convert<_PySequence_,OpenTURNS::Base::Func::Basis>(PyObject * pyObj)
  {
   if (!OpenTURNS::isAPythonSequenceOf<OpenTURNS::_PyObject_>( pyObj )) {
     throw OT::Base::Common::InvalidArgumentException(HERE) << "Argument is not a sequence of objects";
   }

  OpenTURNS::Pointer<Base::Type::Collection<OpenTURNS::Base::Func::NumericalMathFunction> > ptr = buildCollectionFromPySequence<OpenTURNS::Base::Func::NumericalMathFunction>(pyObj);

   return OpenTURNS::Base::Func::Basis( *ptr );
  }

} /* namespace OpenTURNS */

%}

%template(NumericalMathFunctionCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Func::NumericalMathFunction>;
%template(NumericalMathFunctionPersistentCollection) OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Base::Func::NumericalMathFunction>;

%include Basis.hxx
namespace OpenTURNS { namespace Base { namespace Func {

%extend Basis {

Basis(const Basis & other)
{
  return new OpenTURNS::Base::Func::Basis(other);
}

Basis(PyObject * pyObj)
{
  return new OpenTURNS::Base::Func::Basis( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Func::Basis>(pyObj) );
}

}

}}}
