//                                               -*- C++ -*-
/**
 *  @file  t_LinearModelTest_std.cxx
 *  @brief The test file of class Test
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_LinearModelTest_std.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <iomanip>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "LinearModelTest.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"
#include "Normal.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::StatTest;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  UnsignedLong size(100);
  UnsignedLong dim(10);
  CorrelationMatrix R(dim);
  for (UnsignedLong i = 0; i < dim; i++)
    {
      for (UnsignedLong j = 0; j < i; j++)
        {
          R(i, j) = (i + j + 1.0) / (2.0 * dim);
        }
    }
  NumericalPoint mean(dim, 2.0);
  NumericalPoint sigma(dim, 3.0);
  Normal distribution(mean, sigma, R);
  NumericalSample sample(distribution.getNumericalSample(size));
  NumericalSample sampleX(size, dim - 1);
  NumericalSample sampleY(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleY[i][0] = sample[i][0];
      for (UnsignedLong j = 1; j < dim; j++)
        {
          sampleX[i][j - 1] = sample[i][j];
        }
    }
  NumericalSample sampleZ(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleZ[i][0] = sampleY[i][0] * sampleY[i][0];
    }
  fullprint << "LinearModelAdjustedRSquared=" << LinearModelTest::LinearModelAdjustedRSquared(sampleY, sampleZ) << std::endl;
  fullprint << "LinearModelFisher=" << LinearModelTest::LinearModelFisher(sampleY, sampleZ) << std::endl;
  fullprint << "LinearModelResidualMean=" << LinearModelTest::LinearModelResidualMean(sampleY, sampleZ) << std::endl;
  fullprint << "LinearModelRSquared=" << LinearModelTest::LinearModelRSquared(sampleY, sampleZ) << std::endl;
  return ExitCode::Success;
}
