//                                               -*- C++ -*-
/**
 *  @file  t_Exception_std.cxx
 *  @brief The test file of class Exception for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: t_Exception_std.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Exception.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;


template <class EXC>
ExitCodeValue check()
{
  ExitCodeValue rc = ExitCode::Error;

  try {
    throw EXC(HERE) << "This is the reason of the exception";
    std::cerr << "--- Exception not thrown !" << std::endl;
  }
  catch (const EXC & ex) {
    rc = ExitCode::Success;
    std::cerr << "+++ Correct exception catched." << std::endl;
  }
  catch (const Exception & ex) {
    rc = ExitCode::Error;
    std::cerr << "--- General exception catched !" << std::endl;
  }
  catch (const std::exception & ex) {
    rc = ExitCode::Error;
    std::cerr << "--- Standard exception catched !" << std::endl;
  }
  catch (...) {
    rc = ExitCode::Error;
    std::cerr << "--- Unknown exception catched !" << std::endl;
  };

  return rc;
}


int main(int argc, char *argv[])
{
  Log::Show( Log::ALL );

  TESTPREAMBLE;
  OStream fullprint(std::cout);

  ExitCodeValue rc = ExitCode::Success;

  rc |= check< Exception >();
  rc |= check< FileNotFoundException >();
  rc |= check< InternalException >();
  rc |= check< InvalidArgumentException >();
  rc |= check< InvalidDimensionException >();
  rc |= check< NoWrapperFileFoundException >();
  rc |= check< NotYetImplementedException >();
  rc |= check< OutOfBoundException >();
  rc |= check< WrapperFileParsingException >();
  rc |= check< WrapperInternalException >();
  rc |= check< XMLException >();
  rc |= check< XMLParserException >();
  rc |= check< DynamicLibraryException >();
  rc |= check< NotSymmetricDefinitePositiveException >();
  rc |= check< InvalidRangeException >();
  rc |= check< NotDefinedException >();
  rc |= check< FileOpenException >();
  rc |= check< StudyFileParsingException >();
  rc |= check< ObjectNotInStudyException >();
  rc |= check< ConfigurationFileParsingException >();

  return rc;
}
