//                                               -*- C++ -*-
/**
 *  @file  t_Drawable_std.cxx
 *  @brief The test file of class Drawable for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (mar. 24 mai 2011) $
 *  Id:      $Id: t_Drawable_std.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include <cstdlib>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "CorrelationMatrix.hxx"
#include "IdentityMatrix.hxx"
#include "Graph.hxx"
#include "Drawable.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;
using namespace OT::Uncertainty::Distribution;
using namespace std;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {
    fullprint << "Named colors=" << Drawable::GetValidColors() << std::endl;
    fullprint << "RGB colors (31, 63, 127)=" << Drawable::ConvertFromRGB(31UL, 63UL, 127UL) << std::endl;
    fullprint << "RGB colors (0.1, 0.2, 0.3)=" << Drawable::ConvertFromRGB(0.1, 0.2, 0.3) << std::endl;
    fullprint << "RGBA colors (31, 63, 127, 191)=" << Drawable::ConvertFromRGBA(31UL, 63UL, 127UL, 191UL) << std::endl;
    fullprint << "RGBA colors (0.1, 0.2, 0.3, 0.4)=" << Drawable::ConvertFromRGBA(0.1, 0.2, 0.3, 0.4) << std::endl;
    fullprint << "Line styles=" << Drawable::GetValidLineStyles() << std::endl;
    fullprint << "Point styles=" << Drawable::GetValidPointStyles() << std::endl;
    fullprint << "Fill styles=" << Drawable::GetValidFillStyles() << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
