//                                               -*- C++ -*-
/**
 *  @file  ContinuousDistribution.hxx
 *  @brief Abstract top-level class for Continuous distributions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: ContinuousDistribution.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_CONTINUOUSDISTRIBUTION_HXX
#define OPENTURNS_CONTINUOUSDISTRIBUTION_HXX

#include "UsualDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class ContinuousDistribution
       *
       * A subclass for Continuous usual distributions.
       */
      class ContinuousDistribution
        : public UsualDistribution
      {
        static const UnsignedLong DefaultIntegrationNodesNumber;

        CLASSNAME;
      public:

        typedef UsualDistribution::NumericalPoint                          NumericalPoint;
        typedef UsualDistribution::NumericalSample                         NumericalSample;
        typedef UsualDistribution::CovarianceMatrix CovarianceMatrix;
        typedef UsualDistribution::NumericalPointCollection                NumericalPointCollection;
        typedef UsualDistribution::NumericalPointWithDescriptionCollection NumericalPointWithDescriptionCollection;

        /** Default constructor */
        explicit ContinuousDistribution(const String & name = OT::DefaultName);


        /** Virtual constructor */
        virtual ContinuousDistribution * clone() const;

        /** Comparison operator */
        Bool operator ==(const ContinuousDistribution & other) const;

        /** Compute the CDF of Xi | X1, ..., Xi-1. x = Xi, y = (X1,...,Xi-1) */
        NumericalScalar computeConditionalCDF(const NumericalScalar x, const NumericalPoint & y) const;

        /** String converter */
        String __repr__() const;


        /* Methods inherited from upper classes */

        /** Tell if the distribution is Continuous */
        virtual Bool isContinuous() const;

      protected:

        /** Compute the shifted moment of the distribution */
        NumericalPoint computeShiftedMoment(const UnsignedLong n,
                                            const NumericalPoint & shift) const;

        /** Compute the covariance of the distribution */
        void computeCovariance() const;

      private:

      }; /* class ContinuousDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CONTINUOUSDISTRIBUTION_HXX */
