//                                               -*- C++ -*-
/**
 *  @file  TruncatedNormalFactory.cxx
 *  @brief Factory for TruncatedNormal distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: TruncatedNormalFactory.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include "TruncatedNormalFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef Model::DistributionImplementationFactory::NumericalPoint NumericalPoint;

      /* Default constructor */
      TruncatedNormalFactory::TruncatedNormalFactory():
        DistributionImplementationFactory()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      TruncatedNormalFactory * TruncatedNormalFactory::clone() const
      {
        return new TruncatedNormalFactory(*this);
      }


      /* Here is the interface that all derived class must implement */

      TruncatedNormal * TruncatedNormalFactory::build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
        if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a TruncatedNormal distribution from an empty sample";
        if (sample.getDimension() != 1) throw InvalidArgumentException(HERE) << "Error: can build a TruncatedNormal distribution only from a sample of dimension 1, here dimension=" << sample.getDimension();
        // The method runRFactory checks the ability for R to compute parameters estimates
        const NumericalPoint parametersValue(runRFactory(sample, TruncatedNormal()));
        // Next, we try to build a TruncatedNormal distribution, which checks the parameters validity
        try {
          return TruncatedNormal(parametersValue[0], parametersValue[1], parametersValue[2], parametersValue[3]).clone();
        }
        catch (InvalidArgumentException & ex)
          {
            throw InternalException(HERE) << "Error: the estimated parameters values are not valid, mu=" << parametersValue[0] << ", sigma=" << parametersValue[1] << ", a=" << parametersValue[2] << ", b=" << parametersValue[3];
          }
      }

      TruncatedNormal * TruncatedNormalFactory::build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */
      {
        try {
          TruncatedNormal distribution;
          distribution.setParametersCollection(parameters);
          return distribution.clone();
        }
        catch (InvalidArgumentException & ex)
          {
            throw InternalException(HERE) << "Error: cannot build a TruncatedNormal distribution from the given parameters";
          }
      }

      TruncatedNormal * TruncatedNormalFactory::build() const /* throw(InvalidArgumentException, InternalException) */
      {
        return TruncatedNormal().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
