//                                               -*- C++ -*-
/**
 *  @file  LogisticFactory.hxx
 *  @brief Factory for Logistic distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: LogisticFactory.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_LOGISTICFACTORY_HXX
#define OPENTURNS_LOGISTICFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Logistic.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class LogisticFactory
       */
      class LogisticFactory
        : public Model::DistributionImplementationFactory
      {
      public:

        typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
        typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
        typedef DistributionImplementationFactory::InternalException        InternalException;
        typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;

        /** Default constructor */
        LogisticFactory();

        /** Virtual constructor */
        virtual LogisticFactory * clone() const;

        /* Here is the interface that all derived class must implement */
        using DistributionImplementationFactory::build;

        Logistic * build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
        Logistic * build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
        Logistic * build() const /* throw(InvalidArgumentException, InternalException) */;


      }; /* class LogisticFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOGISTICFACTORY_HXX */
