//                                               -*- C++ -*-
/**
 *  @file  BetaFactory.hxx
 *  @brief Factory for Beta distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-07-28 18:31:43 +0200 (Thu, 28 Jul 2011) $
 *  Id:      $Id: BetaFactory.hxx 2046 2011-07-28 16:31:43Z schueller $
 */
#ifndef OPENTURNS_BETAFACTORY_HXX
#define OPENTURNS_BETAFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Beta.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class BetaFactory
       */
      class BetaFactory
        : public Model::DistributionImplementationFactory
      {
      public:

        typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
        typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
        typedef DistributionImplementationFactory::InternalException        InternalException;
        typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;

        /** Default constructor */
        BetaFactory();

        /** Virtual constructor */
        virtual BetaFactory * clone() const;

        /* Here is the interface that all derived class must implement */
        using DistributionImplementationFactory::build;

        Beta * build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
        Beta * build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
        Beta * build() const /* throw(InvalidArgumentException, InternalException) */;


      }; /* class BetaFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BETAFACTORY_HXX */
