//                                               -*- C++ -*-
/**
 *  @file  SVMKernelImplementation.hxx
 *  @brief This is a abstract class for the kernels used by support vector regression
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_SVMKERNELIMPLEMENTATION_HXX
#define OPENTURNS_SVMKERNELIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalPointWithDescription.hxx"
#include "SymmetricMatrix.hxx"
#include "Exception.hxx"
#include "Description.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class SVMKernelImplementation
       *
       * This is a abstract class for the kernels used by support vector regression
       */

      class SVMKernelImplementation
        :       public Base::Common::PersistentObject

      {
        CLASSNAME;
      public:

        typedef OT::NumericalScalar NumericalScalar;
        typedef Base::Type::NumericalPoint                                                                              NumericalPoint;
        typedef Base::Type::NumericalPointWithDescription                       NumericalPointWithDescription;
        typedef Base::Type::SymmetricMatrix                                                                             SymmetricMatrix;
        typedef Base::Common::InvalidArgumentException                          InvalidArgumentException;
        typedef Base::Common::InternalException                                                         InternalException;
        typedef Base::Common::NotYetImplementedException NotYetImplementedException;
        typedef Base::Type::Description                                                                                         Description;

        /** Default constructor */
        SVMKernelImplementation();

        /** Virtual constructor */
        virtual SVMKernelImplementation * clone() const;

        /** String converter */
        virtual String __repr__() const;

        /** Parameter accessor */
        virtual NumericalScalar getParameter() const;
        virtual void setParameter(NumericalScalar value);

        /** Parameters value and description accessor */
        virtual NumericalPointWithDescription getParameters() const;
        virtual void setParameters(const NumericalPointWithDescription & parameters);

        /** Operator () */
        virtual NumericalScalar operator () (const NumericalPoint & x1, const NumericalPoint & x2) const;

        /** Partial gradient */
        virtual NumericalPoint partialGradient(const NumericalPoint & x1, const NumericalPoint & x2) const;

        /** Partial hessian */
        virtual SymmetricMatrix partialHessian(const NumericalPoint & x1, const NumericalPoint & x2) const;

      protected:


      private:

      } ; /* class SVMKernelImplementation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SVMKERNELIMPLEMENTATION_HXX */
