//                                               -*- C++ -*-
/**
 *  @file  OTStat.hxx
 *  @brief The external header file of Open TURNS for subdir Stat
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009) $
 *  Id:      $Id: OTStat.hxx 1129 2009-02-11 15:49:59Z dutka $
 */

#ifndef OPENTURNS_OTSTAT_HXX
#define OPENTURNS_OTSTAT_HXX

#include "Compact.hxx"
#include "ConfidenceInterval.hxx"
#include "CorrelationAnalysis.hxx"
#include "CorrelationMatrix.hxx"
#include "CovarianceMatrix.hxx"
#include "csv_parser_state.hxx"
#include "Full.hxx"
#include "InverseHaltonSequence.hxx"
#include "FaureSequence.hxx"
#include "HaltonSequence.hxx"
#include "HistoryStrategy.hxx"
#include "HistoryStrategyImplementation.hxx"
#include "Last.hxx"
#include "LinearModelFactory.hxx"
#include "LinearModel.hxx"
#include "LowDiscrepancySequence.hxx"
#include "LowDiscrepancySequenceImplementation.hxx"
#include "Null.hxx"
#include "NumericalSample.hxx"
#include "NumericalSampleImplementation.hxx"
#include "RandomGenerator.hxx"
#include "SensitivityAnalysis.hxx"
#include "SobolIndicesParameters.hxx"
#include "SobolIndicesResult.hxx"
#include "SobolSequence.hxx"
#include "TestResult.hxx"

#endif /* OPENTURNS_OTSTAT_HXX */
