//                                               -*- C++ -*-
/**
 *  @file  LinearModelFactory.hxx
 *  @brief Factory for linear model
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: LinearModelFactory.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_LINEARMODELFACTORY_HXX
#define OPENTURNS_LINEARMODELFACTORY_HXX

#include "LinearModel.hxx"
#include "NumericalSample.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class LinearModelFactory
       *
       * Factory for linear model
       */

      class LinearModelFactory
      {
      public:

        typedef Common::InvalidArgumentException InvalidArgumentException;

        static const NumericalScalar DefaultLevelValue;

        /** Default constructor */
        LinearModelFactory();

        /** LinearModel creation
         * @deprecated
         * This method is deprecated. Use buildLinearModel() instead.
         */
        LinearModel buildLM(const NumericalSample & samplePred,
                            const NumericalSample & sampleLab,
                            const NumericalScalar levelValue = DefaultLevelValue) const DEPRECATED /* throw(InvalidArgumentException) */;

        /** LinearModel creation */
        LinearModel build(const NumericalSample & samplePred,
                          const NumericalSample & sampleLab,
                          const NumericalScalar levelValue = DefaultLevelValue) const /* throw(InvalidArgumentException) */;

      }
        ; /* class LinearModelFactory */


    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LINEARMODELFACTORY_HXX */
