//                                               -*- C++ -*-
/**
 *  @file  Bisection.hxx
 *  @brief Implementation class of the scalar nonlinear solver based on
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Bisection.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_BISECTION_HXX
#define OPENTURNS_BISECTION_HXX

#include "OTprivate.hxx"
#include "SolverImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Solver {


      /**
       * @class Bisection
       *
       * This class is an interface for the 1D nonlinear solverImplementations
       */
      class Bisection :
        public SolverImplementation
      {
        CLASSNAME;
      public:

        typedef SolverImplementation::NumericalMathFunction NumericalMathFunction;
        typedef SolverImplementation::InvalidDimensionException InvalidDimensionException;
        typedef SolverImplementation::InternalException InternalException;

        /** Default constructor */
        explicit Bisection();

        /** Parameter constructor */
        Bisection(const NumericalScalar absoluteError,
                  const NumericalScalar relativeError,
                  const UnsignedLong maximumFunctionEvaluation);



        /** Virtual constructor */
        virtual Bisection * clone() const;

        /** String converter */
        String __repr__() const;

        /** Solve attempt to find one root to the equation function(x) = value in [infPoint, supPoint] given function(infPoint) and function(supPoint) with the bisection method */
        using SolverImplementation::solve;
        NumericalScalar solve(const NumericalMathFunction & function,
                              const NumericalScalar value,
                              const NumericalScalar infPoint,
                              const NumericalScalar supPoint,
                              const NumericalScalar infValue,
                              const NumericalScalar supValue)
          /* throw(InternalException, InvalidDimensionException) */;

      private:

      }; /* Class Bisection */

    } /* namespace Solver */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BISECTION_HXX */
