//                                               -*- C++ -*-
/**
 *  @file  NearestPointChecker.hxx
 *  @brief NearestPointChecker checks wether the nearest point found is really the nearestpoint
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-08-01 13:42:13 +0200 (Mon, 01 Aug 2011) $
 *  Id:      $Id: NearestPointChecker.hxx 2060 2011-08-01 11:42:13Z schueller $
 */
#ifndef OPENTURNS_NEARESTPOINTCHECKER_HXX
#define OPENTURNS_NEARESTPOINTCHECKER_HXX

#include "OTprivate.hxx"
#include "Threadable.hxx"
#include "Pointer.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalSample.hxx"
#include "ComparisonOperator.hxx"
#include "PersistentObject.hxx"
#include "NearestPointCheckerResult.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class NearestPointChecker
       *  checks wether the nearest point found is really the nearestpoint
       *
       */

      class NearestPointChecker
        : public Common::PersistentObject,
          public Common::Threadable
      {
        CLASSNAME;
      public:

        typedef Stat::NumericalSample       NumericalSample;
        typedef Func::NumericalMathFunction NumericalMathFunction;
        typedef Common::ComparisonOperator  ComparisonOperator;

        /** Constructor with parameters */
        explicit NearestPointChecker(const NumericalMathFunction & levelFunction,
                                     const ComparisonOperator & comparisonOperator,
                                     const NumericalScalar threshold,
                                     const NumericalSample & sample);


        /** Virtual constructor */
        virtual NearestPointChecker * clone() const;

        /** levelFunction  accessor */
        void setLevelFunction(const NumericalMathFunction & levelFunction);

        /** levelFunction accessor */
        NumericalMathFunction getLevelFunction() const ;

        /** Result accessor */
        void setResult(const NearestPointCheckerResult result );

        /** Result accessor */
        NearestPointCheckerResult getResult() const;

        /** Comparison operator accessor */
        void setComparisonOperator(const ComparisonOperator & comparisonOperator );

        /** Comparison operator accessor */
        ComparisonOperator getComparisonOperator() const ;

        /** threshold accessor */
        void setThreshold(const NumericalScalar threshold);

        /** threshold accessor */
        NumericalScalar getThreshold() const ;

        /** sample accessor */
        void setSample(const NumericalSample & sample);

        /** sample accessor */
        const NumericalSample & getSample() const ;

        /** Performs the actual test */
        void  run();

        /** String converter */
        String __repr__() const;

      private:

        NumericalMathFunction levelFunction_;
        NearestPointCheckerResult result_;
        ComparisonOperator comparisonOperator_;
        NumericalScalar threshold_;
        NumericalSample sample_;
      } ; /* class NearestPointChecker */
      

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NEARESTPOINTCHECKER_HXX */
