//                                               -*- C++ -*-
/**
 *  @file  Pie.hxx
 *  @brief Pie class for piechart plots
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Pie.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_PIE_HXX
#define OPENTURNS_PIE_HXX

#include "DrawableImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      /**
       * @class Pie
       *
       * The class describing a pie chart
       * Instance of Drawable
       */


      class Pie : public DrawableImplementation
      {

        CLASSNAME;

      public:

        typedef DrawableImplementation::NumericalPoint           NumericalPoint;
        typedef DrawableImplementation::Description              Description;
        typedef DrawableImplementation::NumericalSample          NumericalSample;
        typedef DrawableImplementation::InvalidArgumentException InvalidArgumentException;

        static const NumericalScalar HorizontalMargin;
        static const NumericalScalar VerticalMargin;
        static const NumericalScalar LabelThreshold;

        /** Default constructor */
        Pie(const NumericalSample & data);

        /** Constructor with parameters */
        Pie(const NumericalSample & data,
            const Description & labels,
            const NumericalPoint & center,
            const NumericalScalar & radius,
            const Description & palette)
          /* throw(InvalidArgumentException) */;

        /** String converter */
        String __repr__() const;

        /** Accessor for center */
        NumericalPoint getCenter() const;
        void setCenter(const NumericalPoint & center);

        /** Accessor for radius */
        NumericalScalar getRadius() const;
        void setRadius(const NumericalScalar radius);

        /** Accessor for labels */
        Description getLabels() const;
        void setLabels(const Description & labels);

        /** Accessor for color palette */
        Description getPalette() const;
        void setPalette(const Description & palette)
          /* throw(InvalidArgumentException) */;

        /** Check for data validity */
        Bool isValidData(const NumericalSample & data) const;

        /** Accessor for boundingbox */
        BoundingBox getBoundingBox() const;

        /** Draw method */
        String draw() const;

        /** Clone method */
        Pie * clone() const;

        /** Check for color palette validity */
        Bool isValidColorPalette(const Description & palette);

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() stores the object through the StorageManager */
        void load(StorageManager::Advocate & adv);

      private:

        Pie() {};
        friend class Common::Factory<Pie>;

        /** Collection of Strings representing the color palettes */
        Description palette_;

        /** Radius of the Pie */
        NumericalScalar radius_;

        /** Centre of the Pie */
        NumericalPoint center_;

        /** Labels of the pie sectors */
        Description labels_;

      }; /* class Pie */

    }/* namespace Graph */

  }/*namespace Base */

}/* namespace OpenTURNS */

#endif /* OPENTURNS_PIE_HXX */
