//                                               -*- C++ -*-
/**
 *  @file  ProductNumericalMathFunction.hxx
 *  @brief The class that implements product numerical math functions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-07-03 08:31:34 +0200 (jeu, 03 jui 2008) $
 *  Id:      $Id: ProductNumericalMathFunction.hxx 867 2008-07-03 06:31:34Z lebrun $
 */
#ifndef OPENTURNS_PRODUCTNUMERICALMATHFUNCTION_HXX
#define OPENTURNS_PRODUCTNUMERICALMATHFUNCTION_HXX

#include "NumericalMathFunctionImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ProductNumericalMathFunction
       */

      class ProductNumericalMathFunction
        : public NumericalMathFunctionImplementation
      {
        CLASSNAME;
      public:

        /* Some typedefs for easy reading */
        typedef NumericalMathFunctionImplementation::Implementation Implementation;
        typedef NumericalMathFunctionImplementation::NumericalPoint NumericalPoint;
        typedef NumericalMathFunctionImplementation::Matrix         Matrix;
        typedef NumericalMathFunctionImplementation::StorageManager StorageManager;

        /** Composition constructor */
        ProductNumericalMathFunction(const Implementation & p_left,
                                     const Implementation & p_right);

        /** Virtual constructor */
        virtual ProductNumericalMathFunction * clone() const;

        /** Comparison operator */
        Bool operator ==(const ProductNumericalMathFunction & other) const;

        /** String converter */
        virtual String __repr__() const;



        /** Gradient according to the marginal parameters */
        virtual Matrix parametersGradient(const NumericalPoint & inP) const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:

        ProductNumericalMathFunction() {};
        friend class Common::Factory<ProductNumericalMathFunction>;

      private:

        /** The f function in fog */
        Implementation p_leftFunction_;

        /** The g function in fog */
        Implementation p_rightFunction_;

      }; /* class ProductNumericalMathFunction */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PRODUCTNUMERICALMATHFUNCTION_HXX */
