//                                               -*- C++ -*-
/**
 *  @file  LARLasso.hxx
 *  @brief A factory for building BasisSequence objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: LARLasso.hxx 1649 2010-11-09 12:44:00Z dutka $
 */
#ifndef OPENTURNS_LARLASSO_HXX
#define OPENTURNS_LARLASSO_HXX

#include "BasisSequenceFactoryImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      /**
       * @class LARLasso
       *
       * A sequence of numerical math function collection.
       */
      class LARLasso
        : public BasisSequenceFactoryImplementation
      {
      public:

        typedef Common::StorageManager StorageManager;

        /** Default constructor */
        LARLasso(const Bool verbose = false);

        /** Virtual constructor */
        virtual LARLasso * clone() const;

        /** Method to create new BasisSequence objects */
        virtual BasisSequence build(const NumericalSample & x,
				    const NumericalSample & y,
				    const Basis & psi) const;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset = "") const;

        /* Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /* Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      }; /* class LARLasso */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LARLASSO_HXX */
