//                                               -*- C++ -*-
/**
 *  @file  ComputedNumericalMathGradientImplementation.hxx
 *  @brief Abstract top-level class for all ComputedNumerical math functions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: ComputedNumericalMathGradientImplementation.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_COMPUTEDNUMERICALMATHGRADIENTIMPLEMENTATION_HXX
#define OPENTURNS_COMPUTEDNUMERICALMATHGRADIENTIMPLEMENTATION_HXX

#include "NumericalMathGradientImplementation.hxx"
#include "Pointer.hxx"
#include "NumericalPoint.hxx"
#include "Matrix.hxx"
#include "WrapperFile.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /* Forward declaration */
      class WrapperObject;

      /**
       * @class ComputedNumericalMathGradientImplementation
       *
       * This class acts like an real numerical mathematical gradient
       * into the platform. It realizes the computation of the image vector
       * of a vector (aka NumericalPoint) through the function. The
       * function may be loaded in an external way through a wrapper.
       */
      class ComputedNumericalMathGradientImplementation
        : public NumericalMathGradientImplementation
      {
        CLASSNAME;

      public:

        /* Some typedefs to ease reading */
        typedef Common::WrapperInternalException                              WrapperInternalException;
        typedef NumericalMathGradientImplementation::InvalidArgumentException InvalidArgumentException;
        typedef NumericalMathGradientImplementation::InternalException        InternalException;
        typedef Pointer<WrapperObject>                                InternalGradient;
        typedef NumericalMathGradientImplementation::NumericalPoint           NumericalPoint;
        typedef NumericalMathGradientImplementation::Matrix                   Matrix;

        /** Default constructor */
        ComputedNumericalMathGradientImplementation(const String & name, const WrapperFile & file, void * p_state = 0)
          /* throw(WrapperInternalException) */;

        /** Copy constructor */
        ComputedNumericalMathGradientImplementation(const ComputedNumericalMathGradientImplementation & other)
          /* throw(WrapperInternalException) */;

        /** Virtual constructor */
        virtual ComputedNumericalMathGradientImplementation * clone() const;

        /** Destructor */
        virtual ~ComputedNumericalMathGradientImplementation();

        /** Comparison operator */
        Bool operator ==(const ComputedNumericalMathGradientImplementation & other) const;

        /** String converter */
        String __repr__() const;
        virtual String __str__(const String & offset = "") const;



        /* Here is the interface that all derived class must implement */

        /** Gradient method */
        virtual Matrix gradient(const NumericalPoint & inP) const
          /* throw(InvalidArgumentException,InternalException) */;

        /** Accessor for input point dimension */
        virtual UnsignedLong getInputDimension() const
          /* throw(InternalException) */;

        /** Accessor for output point dimension */
        virtual UnsignedLong getOutputDimension() const
          /* throw(InternalException) */;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:

        /** The function object that is linked to the external code */
        InternalGradient p_gradient_;

        /** State management */
        void * getState() const;

      private:
        ComputedNumericalMathGradientImplementation() {};
        friend class Common::Factory<ComputedNumericalMathGradientImplementation>;

        /** A pointer to an internal structure that saves the state of the function into the wrapper */
        void * p_state_;

        /** A flag that is true when the gradient shares its internal state with its related function */
        Bool commonState_;

      }; /* class ComputedNumericalMathGradientImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPUTEDNUMERICALMATHGRADIENTIMPLEMENTATION_HXX */
