//                                               -*- C++ -*-
/**
 *  @file  Os.cxx
 *  @brief This class provides operating system specific variables
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-04-30 12:04:13 +0200 (jeu 30 avr 2009) $
 *  Id:      $Id: Path.cxx 1219 2009-04-30 10:04:13Z dutka $
 */

#include "Os.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Common
    {

      const char * Os::GetDirectorySeparator()
      {
#ifndef WIN32
        return "/";
#else
        return "\\";
#endif
      }

      const char * Os::GetDirectoryListSeparator()
      {
#ifndef WIN32
        return ":";
#else
        return ";";
#endif
      }

      const char * Os::GetEndOfLine()
      {
#ifndef WIN32
        return "\n";
#else
        return "\r\n";
#endif
      }

      String Os::GetDeleteCommandOutput()
      {
#ifndef WIN32
        return " > /dev/null 2>&1";
#else
        return " > NUL";
#endif
      }

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
