//                                               -*- C++ -*-
/**
 *  @file  Object.cxx
 *  @brief The class Object is the top-most class of Open TURNS
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Object.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "Object.hxx"
#include "OSS.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(Object);

      /* Destructor */
      Object::~Object()
      {
        // Nothing to do
      }

      /* String converter */
      String Object::__repr__() const
      {
        return OSS() << "class=" << getClassName();
      }

      /* Pretty string converter */
      String Object::__str__(const String & offset) const
      {
        return __repr__();
      }

      /* Output stream converter */
      std::ostream & operator <<(std::ostream & os, const Object & obj)
      {
        return os << obj.__str__();
      }

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
