//                                               -*- C++ -*-
/**
 *  @file  t_Log_std.cxx
 *  @brief The test file of class Log for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: t_Log_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <sstream>
#include <pthread.h>
#include "OTtestcode.hxx"
#include "OStream.hxx"
#ifdef WIN32
// MinGW pthread.h includes windows.h which define a HUGE number of macros..
#undef ERROR
#endif
#include "Log.hxx"
 
using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;

const int N = 1000;


void* printDebug(void*)
{
  for(int i=0; i<N; i++) {
    OSS oss;
    oss << "Debug #" << i;
    Log::Debug(oss);
  }

  return NULL;
}


void* printInfo(void*)
{
  for(int i=0; i<N; i++) {
    OSS oss;
    oss << "Info #" << i;
    Log::Info(oss);
  }

  return NULL;
}


void* printWrapper(void*)
{
  for(int i=0; i<N; i++) {
    OSS oss;
    oss << "Warn #" << i;
    Log::Wrapper(oss);
  }

  return NULL;
}


void* printUser(void*)
{
  for(int i=0; i<N; i++) {
    OSS oss;
    oss << "Warn #" << i;
    Log::User(oss);
  }

  return NULL;
}


void* printWarn(void*)
{
  for(int i=0; i<N; i++) {
    OSS oss;
    oss << "Warn #" << i;
    Log::Warn(oss);
  }

  return NULL;
}


void* printError(void*)
{
  for(int i=0; i<N; i++) {
    OSS oss;
    oss << "Error #" << i;
    Log::Error(oss);
  }

  return NULL;
}


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  ExitCodeValue rc = ExitCode::Success;

  // Create a thread for messages of every level
  pthread_t tidDebug, tidInfo, tidWrapper, tidUser, tidWarn, tidError;
  pthread_create(&tidDebug, 0, printDebug, 0);
  pthread_create(&tidInfo,  0, printInfo,  0);
  pthread_create(&tidWrapper,  0, printWrapper,  0);
  pthread_create(&tidUser,  0, printUser,  0);
  pthread_create(&tidWarn,  0, printWarn,  0);
  pthread_create(&tidError, 0, printError, 0);

  Log::SetFile("Log_check.log");

  // Wait for threads of messages
  pthread_join(tidDebug, 0);
  pthread_join(tidInfo,  0);
  pthread_join(tidWrapper,  0);
  pthread_join(tidUser,  0);
  pthread_join(tidWarn,  0);
  pthread_join(tidError, 0);

  // const UnsignedLong expectedLength = 4 * N;
  // UnsignedLong actualLength = Log::GetInstance().getSize();

  // if (actualLength != expectedLength) rc = ExitCode::Error;

  return rc;
}
