//                                               -*- C++ -*-
/**
 *  @file  NonEllipticalDistribution.cxx
 *  @brief Abstract top-level class for non elliptical distributions
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NonEllipticalDistribution.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "NonEllipticalDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(NonEllipticalDistribution);

      /* Default constructor */
      NonEllipticalDistribution::NonEllipticalDistribution(const String & name)
	: ContinuousDistribution(name)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      DistributionImplementation * NonEllipticalDistribution::clone() const
      {
        return new NonEllipticalDistribution(*this);
      }

      /* Comparison operator */
      Bool NonEllipticalDistribution::operator ==(const NonEllipticalDistribution & other) const {
	Bool sameObject = false;

	if (this != &other) { // Other is NOT me, so I have to realize the comparison
	  // sameObject = ...
	} else sameObject = true;

	return sameObject;
      }
  
      /* String converter */
      String NonEllipticalDistribution::__repr__() const {
	OSS oss;
	oss << "class=" << NonEllipticalDistribution::GetClassName();
	return oss;
      }
  
    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
