//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategyImplementation.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SamplingStrategyImplementation.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "SamplingStrategyImplementation.hxx"
#include "Exception.hxx"
#include "DistFunc.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;
      typedef Distribution::DistFunc                   DistFunc;

      /**
       * @class SamplingStrategyImplementation
       */

      CLASSNAMEINIT(SamplingStrategyImplementation);

      /* Constructor with parameters */
      SamplingStrategyImplementation::SamplingStrategyImplementation(const UnsignedLong dimension)
	: Base::Common::PersistentObject(),
	  dimension_(dimension)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      SamplingStrategyImplementation * SamplingStrategyImplementation::clone() const
      {
	return new SamplingStrategyImplementation(*this);
      }

      /* Generate a set of directions */
      SamplingStrategyImplementation::NumericalSample SamplingStrategyImplementation::generate() const
      {
	throw NotYetImplementedException(HERE);
      }

      /* Generate a uniform random unit vector */
      SamplingStrategyImplementation::NumericalPoint SamplingStrategyImplementation::getUniformUnitVectorRealization(const UnsignedLong dimension) const
      {
	NumericalPoint direction(dimension);
	NumericalScalar norm(0.0);
	do
	  {
	    for (UnsignedLong i = 0; i < dimension; i++)
	      {
		direction[i] = DistFunc::rNormal();
	      }
	    norm = direction.norm();
	  }
	while (norm == 0.0);
	return (1.0 / norm) * direction;
      }

      /* Generate a uniform random unit vector */
      SamplingStrategyImplementation::NumericalPoint SamplingStrategyImplementation::getUniformUnitVectorRealization() const
      {
	return getUniformUnitVectorRealization(dimension_);
      }

      /* Dimension accessor */
      void SamplingStrategyImplementation::setDimension(const UnsignedLong dimension)
      {
	dimension_ = dimension;
      }

      UnsignedLong SamplingStrategyImplementation::getDimension() const
      {
	return dimension_;
      }

      /* String converter */
      String SamplingStrategyImplementation::__repr__() const
      {
	OSS oss;
	oss << "class=" << SamplingStrategyImplementation::GetClassName()
	    << " dimension=" << dimension_;
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
