//                                               -*- C++ -*-
/**
 *  @file  OrthogonalBasis.cxx
 *  @brief This is the interface class for orthogonal basis
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "OrthogonalBasis.hxx"
#include "OSS.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(OrthogonalBasis);

      /* Default constructor */
      OrthogonalBasis::OrthogonalBasis()
	: Base::Common::TypedInterfaceObject<OrthogonalFunctionFactory>()
      {
	// Nothing to do
      }

      
      /* Constructor from implementation */
      OrthogonalBasis::OrthogonalBasis(const OrthogonalFunctionFactory & implementation)
	: Base::Common::TypedInterfaceObject<OrthogonalFunctionFactory>(implementation.clone())
      {
	// Nothing to do
      }


      /* Build the NumericalMathFunction of the given index */
      OrthogonalBasis::NumericalMathFunction OrthogonalBasis::build(const UnsignedLong index) const
      {
	return getImplementation()->build(index);
      }


      /* Return the measure upon which the basis is orthogonal */
      OrthogonalBasis::Distribution OrthogonalBasis::getMeasure() const
      {
	return getImplementation()->getMeasure();
      }

      /* Return the enumerate function that translate unidimensional indices nto multidimensional indices */
      EnumerateFunction OrthogonalBasis::getEnumerateFunction() const
      {
	return getImplementation()->getEnumerateFunction();
      }

      /* String converter */
      String OrthogonalBasis::__repr__() const
      {
	return OSS() << "class=" << getClassName()
      		     << " implementation=" << getImplementation()->__repr__();
      }



    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
