//                                               -*- C++ -*-
/**
 *  @file  HistoryStrategyImplementation.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: HistoryStrategyImplementation.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "HistoryStrategyImplementation.hxx"
#include "Exception.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base 
  {

    namespace Stat
    {

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /**
       * @class HistoryStrategyImplementation
       */

      CLASSNAMEINIT(HistoryStrategyImplementation);
      
      static Base::Common::Factory<HistoryStrategyImplementation> RegisteredFactory("HistoryStrategyImplementation");

      /* Constructor with parameters */
      HistoryStrategyImplementation::HistoryStrategyImplementation()
	: Base::Common::PersistentObject(),
	  sample_(),
	  isInitialized_(false)
      {
	// Nothing to do
      }
      
      /* Virtual constructor */
      HistoryStrategyImplementation * HistoryStrategyImplementation::clone() const
      {
	return new HistoryStrategyImplementation(*this);
      }

      /* Store the point according to the strategy */
      void HistoryStrategyImplementation::store(const NumericalPoint & point)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Reset the history storage through the isInitialized_ flag */
      void HistoryStrategyImplementation::reset()
      {
	isInitialized_ = false;
	sample_ = NumericalSample();
      }

      /* History sample accessor */
      NumericalSample HistoryStrategyImplementation::getSample() const
      {
	return sample_;
      }

      /* String converter */
      String HistoryStrategyImplementation::__repr__() const
      {
	OSS oss;
	oss << "class=" << HistoryStrategyImplementation::GetClassName();
	return oss;
      }

      /** Method save() stores the object through the StorageManager */
      void HistoryStrategyImplementation::save(StorageManager::Advocate & adv) const
      {
        Base::Common::PersistentObject::save(adv);

        adv.saveAttribute("sample_", sample_);
        adv.saveAttribute("isInitialized_",isInitialized_);
        /** Initialization flag */
      }

      /** Method load() reloads the object from the StorageManager */
      void HistoryStrategyImplementation::load(StorageManager::Advocate & adv)
      {
        Base::Common::PersistentObject::load(adv);

        adv.loadAttribute("sample_", sample_);
        adv.loadAttribute("isInitialized_",isInitialized_);
      }
      

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
