//                                               -*- C++ -*-
/**
 *  @file  SQPSpecificParameters.cxx
 *  @brief SpecificParameters is an encapsulation of the SQP specific
 *         parameters.
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SQPSpecificParameters.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <cstdlib>

#include "SQP.hxx"
#include "ResourceMap.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(SQP::SpecificParameters);

      typedef Common::ResourceMap ResourceMap;

      /* Multiplicative decrease of linear step */
      const NumericalScalar SQP::SpecificParameters::DefaultTau    = 0.5;//strtod(ResourceMap::GetInstance().get("SQP-DefaultTau").c_str(), NULL);
      /* Armijo factor */
      const NumericalScalar SQP::SpecificParameters::DefaultOmega  = 1.0e-4;//strtod(ResourceMap::GetInstance().get("SQP-DefaultOmega").c_str(), NULL);
      /* Growing factor in penalization term */
      const NumericalScalar SQP::SpecificParameters::DefaultSmooth = 1.2;//strtod(ResourceMap::GetInstance().get("SQP-DefaultSmooth").c_str(), NULL);

      /* Default onstructor */
      SQP::SpecificParameters::SpecificParameters():
        PersistentObject(),
        tau_(SQP::SpecificParameters::DefaultTau),
        omega_(SQP::SpecificParameters::DefaultOmega),
        smooth_(SQP::SpecificParameters::DefaultSmooth)
      {
        // Nothing to do
      } /* SpecificParametersSQP */

      /* Constructor with parameters */
      SQP::SpecificParameters::SpecificParameters(const NumericalScalar tau,
                                                  const NumericalScalar omega,
                                                  const NumericalScalar smooth):
        PersistentObject(),
        tau_(tau),
        omega_(omega),
        smooth_(smooth)
      {
        // Nothing to do
      } /* SpecificParametersSQP */

      /* Virtual constructor */
      SQP::SpecificParameters * SQP::SpecificParameters::clone() const
      {
        return new SpecificParameters(*this);
      }

      /* Tau accessor */
      NumericalScalar SQP::SpecificParameters::getTau() const
      {
        return tau_;
      }

      /* Tau accessor */
      void SQP::SpecificParameters::setTau(const NumericalScalar tau)
      {
        tau_ = tau;
      }

      /* Omega accessor */
      NumericalScalar SQP::SpecificParameters::getOmega() const
      {
        return omega_;
      }

      /* Omega accessor */
      void SQP::SpecificParameters::setOmega(const NumericalScalar omega)
      {
        omega_ = omega;
      }

      /* Smooth accessor */
      NumericalScalar SQP::SpecificParameters::getSmooth() const
      {
        return smooth_;
      }

      /* Smooth accessor */
      void SQP::SpecificParameters::setSmooth(const NumericalScalar smooth)
      {
        smooth_ = smooth;
      }

      /* String converter */
      String SQP::SpecificParameters::__repr__() const
      {
        OSS oss;
        oss << "class=" << SQP::SpecificParameters::GetClassName()
            << " tau=" << tau_
            << " omega=" << omega_
            << " smooth=" << smooth_;
        return oss;
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */



