//                                               -*- C++ -*-
/**
 *  @file  InterfaceObject.cxx
 *  @brief The abstract class InterfaceObject defines the GetImplementation method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: InterfaceObject.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>              // for std::ostream
#include "InterfaceObject.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(InterfaceObject);

      
      /* String converter */
      String InterfaceObject::__repr__() const
      {
	return getImplementationAsPersistentObject()->__repr__();
      }

      /* String converter */
      String InterfaceObject::__str__() const
      {
	return getImplementationAsPersistentObject()->__str__();
      }

      /* Id accessor */
      Id InterfaceObject::getId() const
      {
	return getImplementationAsPersistentObject()->getId();
      }

      /* Name accessor */
      void InterfaceObject::setName(const String & name)
      {
	getImplementationAsPersistentObject()->setName(name);
      }


      /* Name accessor */
      String InterfaceObject::getName() const
      {
	return getImplementationAsPersistentObject()->getName();
      }


      /* Method save() stores the object through the StorageManager */
      void InterfaceObject::save(StorageManager & mgr, const String & label) const
      {
	getImplementationAsPersistentObject()->save( mgr, label );
      }

      /* Method save() stores the object through the StorageManager */
      void InterfaceObject::save(StorageManager & mgr) const
      {
	getImplementationAsPersistentObject()->save( mgr );
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
