// SWIG file base_all.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-08-28 17:36:47 +0200 (Thu, 28 Aug 2008) $
// Id : $Id: base.i 916 2008-08-28 15:36:47Z dutka $

%module(docstring="Base is the determnistic part of Open TURNS.") base_all
%feature("autodoc","1");

%pythoncode %{
#from openturns.viewer import ViewImage,StopViewer,WaitForViewer

def TESTPREAMBLE():
  """
  TESTPREAMBLE() catches the --version argument on the command line,
  prints a identification string and then exits softly.
  """
  import sys
  if "--version" in sys.argv:
    print sys.argv[0] + " : $Id: base.i 916 2008-08-28 15:36:47Z dutka $"
    sys.exit(0)
%}

%pythoncode %{
def Show(graph):
  try :
    if (Graph(graph).getClassName()=="Graph"):
      from rpy import r
      tmp=r(graph.getRCommand())
      graph.clean()
  except :
    try :
      if (Drawable(graph).getClassName()=="Drawable"):
        from rpy import r
        tmp=r(graph.draw())
        graph.clean()
    except :
      import sys
      print "Error in Show", sys.exc_type, sys.exc_value
%}

%{
#include "OTBase.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import base_common.i

/* Wrapper */
%import base_wrapper.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%include PersistentCollection.i
%include DescriptionImplementation.i
%include Description.i
%include NumericalPointImplementation.i
%include NumericalPoint.i
%include NumericalPointImplementationWithDescription.i
%include NumericalPointWithDescription.i
%include Indices.i
%include Interval.i
%include MatrixImplementation.i
%include Matrix.i
%include SquareMatrix.i
%include SymmetricMatrix.i
%include TensorImplementation.i
%include Tensor.i
%include SymmetricTensor.i
// %include Cache.i

/* Base/Stat */
%include CovarianceMatrix.i
%include CorrelationMatrix.i
%include IdentityMatrix.i
%include NumericalSample.i
%include HistoryStrategyImplementation.i
%include HistoryStrategy.i
%include Compact.i
%include Full.i
%include Last.i
%include Null.i
%include ConfidenceInterval.i
%include LinearModel.i
%include LinearModelFactory.i
%include TestResult.i
%include RandomGenerator.i
%include CorrelationAnalysis.i
%include SensitivityAnalysis.i

/* Base/Graph */
%include DrawableImplementation.i
%include Drawable.i
%include GraphImplementation.i
%include Graph.i
%include BarPlot.i
%include Cloud.i
%include Contour.i
%include Curve.i
%include Pie.i
%include Staircase.i

/* Base/Func */
%include NumericalMathEvaluationImplementation.i
%include NumericalMathGradientImplementation.i
%include NumericalMathHessianImplementation.i
%include NoNumericalMathEvaluationImplementation.i
%include NoNumericalMathGradientImplementation.i
%include NoNumericalMathHessianImplementation.i
%include LinearNumericalMathEvaluationImplementation.i
%include LinearNumericalMathGradientImplementation.i
%include QuadraticNumericalMathEvaluationImplementation.i
%include ConstantNumericalMathGradientImplementation.i
%include ConstantNumericalMathHessianImplementation.i
%include ComputedNumericalMathEvaluationImplementation.i
%include ComputedNumericalMathGradientImplementation.i
%include ComputedNumericalMathHessianImplementation.i
%include ComposedNumericalMathEvaluationImplementation.i
%include ComposedNumericalMathGradientImplementation.i
%include ComposedNumericalMathHessianImplementation.i
%include ProductNumericalMathEvaluationImplementation.i
%include ProductNumericalMathGradientImplementation.i
%include ProductNumericalMathHessianImplementation.i
%include NumericalMathFunctionImplementation.i
%include ComposedNumericalMathFunction.i
%include ProductNumericalMathFunction.i
%include NumericalMathFunction.i
%include LinearCombinationEvaluationImplementation.i
%include LinearCombinationGradientImplementation.i
%include LinearCombinationHessianImplementation.i
%include LinearNumericalMathFunction.i
%include UniVariatePolynomial.i
%include IndicatorNumericalMathEvaluationImplementation.i
%include ProductPolynomialEvaluationImplementation.i

/* Base/Diff */
%include CenteredFiniteDifferenceGradient.i
%include CenteredFiniteDifferenceHessian.i
%include NonCenteredFiniteDifferenceGradient.i

/* Base/Optim */
%include BoundConstrainedAlgorithmImplementation.i
%include BoundConstrainedAlgorithm.i
%include NearestPointAlgorithmImplementation.i
%include NearestPointAlgorithm.i
%include NearestPointChecker.i
%include AbdoRackwitz.i
%include Cobyla.i
%include TNC.i
%include SQP.i
%include LeastSquaresAlgorithm.i

/* Base/Solver */
%include SolverImplementation.i
%include Solver.i
%include Bisection.i
%include Secant.i
%include Brent.i

/* At last we include template definitions */
%include BaseTemplateDefs.i
