//                                               -*- C++ -*-
/**
 *  @file  t_UserDefined_std.cxx
 *  @brief The test file of class UserDefined for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_UserDefined_std.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "UserDefined.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Distribution;


// class TestObject : public UserDefined
// {
// public:
//   explicit TestObject() : UserDefined(1., 1) {}
//   explicit TestObject(const String & name) : UserDefined(1., 1) {setName(name);}
//   virtual ~TestObject() {}
// };


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();  

  try {
    // Test basic functionnalities
    //checkClassWithClassName<TestObject>();

    // Test some extra functionnalities
    //checkNameFeature<TestObject>();

    // Instanciate one distribution object
    typedef UserDefined::Pair Pair;
    typedef UserDefined::PairCollection PairCollection;
    PairCollection collection(3, Pair(NumericalPoint(1), 0.0));
    NumericalPoint point(1);
    point[0] = 1.0;
    collection[0] = Pair(point,0.3);
    point[0] = 2.0;
    collection[1] = Pair(point,0.2);
    point[0] = 3.0;
    collection[2] = Pair(point,0.5);
    UserDefined distribution(collection);
    fullprint << "Distribution " << distribution << std::endl;

    // Is this distribution elliptical ?
    fullprint << "Elliptical = " << (distribution.isElliptical() ? "true" : "false") << std::endl;

    // Is this distribution continuous ?
    fullprint << "Continuous = " << (distribution.isContinuous() ? "true" : "false") << std::endl;

    // Test for realization of distribution
    NumericalPoint oneRealization = distribution.getRealization();
    fullprint << "oneRealization=" << oneRealization << std::endl;

    // Test for sampling
    UnsignedLong size = 10;
    NumericalSample oneSample = distribution.getNumericalSample( size );
    fullprint << "oneSample=" << oneSample << std::endl;

    // Define a point
    point = NumericalPoint( distribution.getDimension(), 2 );

    // Show PDF and CDF of a point
    NumericalScalar pointPDF = distribution.computePDF( point );
    NumericalScalar pointCDF = distribution.computeCDF( point );
    fullprint << "point= " << point 
	      << " pdf=" << pointPDF
	      << " cdf=" << pointCDF
	      << std::endl;

    // Get 95% quantile
    NumericalPoint quantile = distribution.computeQuantile( 0.95 );
    fullprint << "Quantile=" << quantile << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
