//                                               -*- C++ -*-
/**
 *  @file  t_TestResult_std.cxx
 *  @brief The test file of class TestResult
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_TestResult_std.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "TestResult.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  
  /** TEST NUMBER ZERO : DEFAULT CONSTRUCTOR AND STRING CONVERTER */
  fullprint << "test number zero : default constructor and string converter" << std::endl;
  
  /* Default constructor */
  String type = "testResult";
  Bool testBool = 1;
  NumericalScalar testVal = 0.372;
  NumericalScalar testThres = 0.42;
  TestResult testResultTest(type, testBool, testVal, testThres);
  
  /* String converter */
  fullprint << "testResultTest = " << testResultTest << std::endl;
  
  
  /** TEST NUMBER ONE : COPY CONSTRUCTOR AND STRING CONVERTER */
  fullprint << "test number one : copy constructor and string converter" << std::endl;
  
  /* Copy constructor */
  TestResult testResultTest2(testResultTest);
  
  /* String converter */
  fullprint << "testResultTest2 = " << testResultTest2 << std::endl;
  
  
  /** TEST NUMBER TWO : ELEMENTS ACCESSORS */
  fullprint << "test number two : elements accessors" << std::endl;
  fullprint << "testResultTest2 binary quality measure = " << testResultTest2.getBinaryQualityMeasure() << std::endl;
  fullprint << "testResultTest2 p value = " << testResultTest2.getPValue() << std::endl;
  fullprint << "testResultTest2 p value threshold = " << testResultTest2.getThreshold() << std::endl;
  fullprint << "testResultTest2 test type = " << testResultTest2.getTestType() << std::endl;
  
  /** TEST NUMBER THREE : EQUALITY */
  fullprint << "testResultTest2 = testResultTest " << (testResultTest2 == testResultTest) << std::endl;
  String typeDiff = "testResult2";
  Bool testBoolDiff = 0;
  NumericalScalar testValDiff = 0.02;
  NumericalScalar testThresDiff = 0.12;
  TestResult testResultTestDiff(typeDiff, testBoolDiff, testValDiff, testThresDiff);
  fullprint << "testResultTestDiff = testResultTest " << (testResultTestDiff == testResultTest) << std::endl;

	    
  return ExitCode::Success;
}
