//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_analytical.cxx
 *  @brief The test file of class NumericalMathFunction for analytical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_NumericalMathFunction_analytical.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <iomanip>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <sys/time.h>
#include <cmath>
#include "NumericalMathFunction.hxx"
#include "NumericalSample.hxx"
#include "Log.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    /** Analytical construction */
    Description input(4);
    input[0] = "x0";
    input[1] = "x1";
    input[2] = "x2";
    input[3] = "x3";
    fullprint << "input=" << input << std::endl;
    Description output(2);
    output[0] = "y0";
    output[1] = "y1";
    fullprint << "output=" << output << std::endl;
    Description formulas(output.getSize());
    formulas[0] = "x0+sin(x1)+x2";
    formulas[1] = "2*x0+2*x1+2*x2";
    fullprint << "formulas=" << formulas << std::endl;
    NumericalMathFunction analytical(input, output, formulas);

    fullprint << "analytical=" << analytical << std::endl;

    /** Does it work? */
    NumericalPoint x(analytical.getInputNumericalPointDimension(), 1.0);
    fullprint << "x=" << x << std::endl;
    fullprint << "analytical(x)=" << analytical(x) << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
