//                                               -*- C++ -*-
/**
 *  @file  TestIdentity.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-12 14:29:13 +0100 (jeu. 12 févr. 2009) $
 *  Id:      $Id: TestIdentity.cxx 1132 2009-02-12 13:29:13Z dutka $
 */
#include <iostream>
#include <cstdlib>
#include "WrapperInterface.h"

namespace WrapperInternals {
  struct internalState {
    long numberOfCalls;
  };

  void internalStateInitialization(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls = 0;
  }

  void internalStateIncrement(struct internalState * p_internalState)
  {
    if (p_internalState) p_internalState->numberOfCalls++;
  }

  long internalStateGetNumberOfCalls(struct internalState * p_internalState)
  {
    return (p_internalState ? p_internalState->numberOfCalls : -1);
  }
} /* namespace WrapperInternals */

extern "C" {
  /* Function */
  enum WrapperErrorCode func_createState_TestIdentity(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_deleteState_TestIdentity(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  static struct WrapperInformation info_TestIdentity = {/* inSize_  = */ 4,
							/* outSize_ = */ 4};

  enum WrapperErrorCode func_getInfo_TestIdentity(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestIdentity;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_init_TestIdentity(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_TestIdentity(void * p_state, const struct point * inPoint, struct point * outPoint)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    double x1(inPoint->data_[0]);
    double x2(inPoint->data_[1]);
    double x3(inPoint->data_[2]);
    double x4(inPoint->data_[3]);

    outPoint->data_[0] = x1;
    outPoint->data_[1] = x2;
    outPoint->data_[2] = x3;
    outPoint->data_[3] = x4;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_exec_sample_TestIdentity(void * p_state, const struct sample * inSample, struct sample * outSample)
  {
    unsigned long inDimension((inSample->data_[0]).size_);
    if (info_TestIdentity.inSize_ != inDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long outDimension((outSample->data_[0]).size_);
    if (info_TestIdentity.outSize_ != outDimension) return WRAPPER_WRONG_ARGUMENT;
    unsigned long size(inSample->size_);
    for (unsigned long i = 0; i < size; i++)
      {
        if (func_exec_TestIdentity(p_state, &(inSample->data_[i]),  &(outSample->data_[i])) != WRAPPER_OK) return WRAPPER_EXECUTION_ERROR;
      }
    return WRAPPER_OK;
  }

  enum WrapperErrorCode func_finalize_TestIdentity(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Gradient, which is void at this time */
  enum WrapperErrorCode grad_createState_TestIdentity(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_deleteState_TestIdentity(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_getInfo_TestIdentity(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestIdentity;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_init_TestIdentity(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_exec_TestIdentity(void * p_state, const struct point * inPoint, struct matrix * outMatrix)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));
    

    outMatrix->data_[ 0] = 1.0;
    outMatrix->data_[ 1] = 0.0;
    outMatrix->data_[ 2] = 0.0;
    outMatrix->data_[ 3] = 0.0;
    outMatrix->data_[ 4] = 0.0;
    outMatrix->data_[ 5] = 1.0;
    outMatrix->data_[ 6] = 0.0;
    outMatrix->data_[ 7] = 0.0;
    outMatrix->data_[ 8] = 0.0;
    outMatrix->data_[ 9] = 0.0;
    outMatrix->data_[10] = 1.0;
    outMatrix->data_[11] = 0.0;
    outMatrix->data_[12] = 0.0;
    outMatrix->data_[13] = 0.0;
    outMatrix->data_[14] = 0.0;
    outMatrix->data_[15] = 1.0;

    return WRAPPER_OK;
  }

  enum WrapperErrorCode grad_finalize_TestIdentity(void * p_state)
  {
    return WRAPPER_OK;
  }
  /* Hessian, which is void at this time */
  enum WrapperErrorCode hess_createState_TestIdentity(void ** p_p_state, const struct WrapperExchangedData * p_exchangedData)
  {
    *p_p_state = malloc(sizeof(struct WrapperInternals::internalState));
    internalStateInitialization(static_cast<struct WrapperInternals::internalState *>(*p_p_state));
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_deleteState_TestIdentity(void * p_state)
  {
    free(p_state);
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_getInfo_TestIdentity(void * p_state, struct WrapperInformation * p_info)
  {
    *p_info = info_TestIdentity;
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_init_TestIdentity(void * p_state)
  {
    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_exec_TestIdentity(void * p_state, const struct point * inPoint, struct tensor * outTensor)
  {
    internalStateIncrement(static_cast<struct WrapperInternals::internalState *>(p_state));

    for (int i = 0; i < 64; i++)
      outTensor->data_[i] = 0.0;

    return WRAPPER_OK;
  }

  enum WrapperErrorCode hess_finalize_TestIdentity(void * p_state)
  {
    return WRAPPER_OK;
  }
} /* end extern "C" */
