//                                               -*- C++ -*-
/**
 *  @file  QuasiMonteCarloResult.hxx
 *  @brief Implementation of SimulationResult
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-23 13:46:12 +0200 (Fri, 23 May 2008) $
 *  Id:      $Id: QuasiMonteCarloResult.hxx 821 2008-05-23 11:46:12Z schueller $
 */
#ifndef OPENTURNS_QUASIMONTECARLORESULT_HXX
#define OPENTURNS_QUASIMONTECARLORESULT_HXX

#include "SimulationResultImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {


      /**
       * @class QuasiMonteCarloResult
       * Implementation of SimulationResult
       */
      class QuasiMonteCarloResult
	: public SimulationResultImplementation
      {

	CLASSNAME;
      public:

	typedef SimulationResultImplementation::StorageManager             StorageManager;
	typedef SimulationResultImplementation::NotYetImplementedException NotYetImplementedException;

	/** Default constructor */
	explicit QuasiMonteCarloResult();

	/** Standard constructor */
	explicit QuasiMonteCarloResult(const NumericalScalar probabilityEstimate,
				       const NumericalScalar varianceEstimate,
				       const UnsignedLong outerSampling,
				       const UnsignedLong blockSize) throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual QuasiMonteCarloResult * clone() const;

	/** Coefficient of variation estimate accessor */
	virtual NumericalScalar getCoefficientOfVariation() const;

	/** Confidence length */
	virtual NumericalScalar getConfidenceLength(const NumericalScalar level = SimulationResultImplementation::DefaultConfidenceLevel) const
	  throw(InvalidArgumentException);

	/** String converter */
	virtual String __repr__() const;

      private:

      }; // class QuasiMonteCarloResult

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_QUASIMONTECARLORESULT_HXX */
