//                                               -*- C++ -*-
/**
 *  @file  LHS.hxx
 *  @brief LHS is an implementation of the hit or miss Monte Carlo simulation method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: LHS.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_LHS_HXX
#define OPENTURNS_LHS_HXX

#include "Simulation.hxx"
#include "Collection.hxx"
#include "Distribution.hxx"
#include "Matrix.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class LHS
       */

      class LHS: public Simulation
      {

	CLASSNAME;
      public:

	typedef Simulation::NumericalSample                 NumericalSample;
	typedef Simulation::InvalidArgumentException        InvalidArgumentException;
	typedef Base::Type::Collection<Model::Distribution> Marginals;
	typedef Base::Type::Matrix                          Matrix;

	/** Constructor with parameters */
	LHS(const Simulation::Event & event);


	/** Virtual constructor */
	virtual LHS * clone() const;

	/** Shuffle the cells. */
	void computeShuffle();

	/** Performs the actual computation. */
	void run();

	/** String converter */
	String __repr__() const;

      private:

	/** Compute the block sample */
	NumericalSample computeBlockSample();

	/** Second antecedent dimension */
	UnsignedLong dimension_;

	/** Active block index */
	UnsignedLong blockIndex_;

	/** Cells shuffle */
	Matrix shuffle_;

	/** Marginal distributions */
	Marginals marginals_;

      } ; /* class LHS */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LHS_HXX */
