//                                               -*- C++ -*-
/**
 *  @file  NatafIndependentCopulaHessian.hxx
 *  @brief Class for the Nataf transformation evaluation for independent
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NatafIndependentCopulaHessian.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_NATAFINDEPENDENTCOPULAHESSIAN_HXX
#define OPENTURNS_NATAFINDEPENDENTCOPULAHESSIAN_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "SymmetricTensor.hxx"
#include "NumericalPoint.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class NatafIndependentCopulaHessian
       *
       * This class offers an interface for the Nataf function for independent distributions
       */
      class NatafIndependentCopulaHessian
	: public Base::Func::NumericalMathHessianImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathHessianImplementation NumericalMathHessianImplementation;
	typedef Base::Type::SymmetricTensor                    SymmetricTensor;
	typedef Base::Type::NumericalPoint                     NumericalPoint;
	typedef Base::Common::InternalException                InternalException;
	typedef Base::Common::InvalidArgumentException         InvalidArgumentException;

	/** Parameter constructor */
	NatafIndependentCopulaHessian(const UnsignedLong dimension);


	/** Virtual constructor */
	virtual NatafIndependentCopulaHessian * clone() const;

	/** Hessian */
	SymmetricTensor hessian(const NumericalPoint & in) const
	  throw(InvalidArgumentException, InternalException);

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** String converter */
	virtual String __repr__() const;

      protected:

    
      private:
	UnsignedLong dimension_;

      }; /* NatafIndependentCopulaHessian */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NATAFINDEPENDENTCOPULAHESSIAN_HXX */
