//                                               -*- C++ -*-
/**
 *  @file  SORM.hxx
 *  @brief SORM implements the First Order Reliability Method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: SORM.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_SORM_HXX
#define OPENTURNS_SORM_HXX

#include "Analytical.hxx"
#include "Event.hxx"
#include "SquareMatrix.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"
#include "SORMResult.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class SORM
       * SORM implements the Second Order Reliability Method
       * and compute the results of such kind of analyses
       */

      class SORM :
	public Analytical
      {

	CLASSNAME;
      public:

	typedef Analytical::NumericalPoint        NumericalPoint;
	typedef Analytical::Event                 Event;
	typedef Analytical::Sensitivity           Sensitivity;
	typedef Analytical::NearestPointAlgorithm NearestPointAlgorithm;
	typedef Base::Type::SquareMatrix          SquareMatrix;
        typedef Model::Distribution               Distribution;
        typedef Base::Common::NotDefinedException NotDefinedException;

	/** Constructor with parameters */
	SORM(const NearestPointAlgorithm & nearestPointAlgorithm,
	     const Event & event,
	     const NumericalPoint & physicalStartingPoint);


	/** Virtual constructor */
	virtual SORM * clone() const;

	/** Result accessor */
	SORMResult getResult() const;

	/** Result accessor */
	void setResult(const SORMResult & result);

	/** String converter */
	String __repr__() const;

	/** Function that computes the design point by re-using the Analytical::run() and creates a SORM::Result */
	void run();

      private:

	SORMResult result_;

      } ; /* class SORM */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SORM_HXX */
