//                                               -*- C++ -*-
/**
 *  @file  NumericalPointWithDescription.hxx
 *  @brief NumericalPointWithDescription extends the classical mathematical point with the description of the coordinates
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NumericalPointWithDescription.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX
#define OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX

#include "NumericalPoint.hxx"
#include "NumericalPointImplementationWithDescription.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @class NumericalPointWithDescription
       *
       * NumericalPointWithDescription extends the classical mathematical point with the description of the coordinates
       */

      class NumericalPointWithDescription :
	public NumericalPoint
      {
	CLASSNAME;

	typedef Common::Pointer<NumericalPointImplementationWithDescription> Implementation;

      public:

	typedef Common::InvalidArgumentException              InvalidArgumentException;

	/** Default constructor */
	NumericalPointWithDescription();

	/** Constructor with size */
	NumericalPointWithDescription(const UnsignedLong size,
				      const NumericalScalar value = 0.0);

	/** Constructor from implementation */
	NumericalPointWithDescription(const NumericalPointImplementationWithDescription & implementation);

	/** Constructor from NumericalPoint  */
	NumericalPointWithDescription(const NumericalPoint & point);

	/** Description Accessor */
	virtual void setDescription(const Description & description);
	virtual Description getDescription() const;

	/** String converter */
	virtual String __repr__() const;
	virtual String __str__() const;

      }; /* class NumericalPointWithDescription */

      

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX */
