//                                               -*- C++ -*-
/**
 *  @file  NumericalPointWithDescription.cxx
 *  @brief NumericalPointWithDescription extends the classical mathematical point with the description of the coordinates
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NumericalPointWithDescription.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "NumericalPointWithDescription.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {


      CLASSNAMEINIT(NumericalPointWithDescription);
      TEMPLATE_CLASSNAMEINIT(PersistentCollection<NumericalPointWithDescription>);

      static Common::Factory<PersistentCollection<NumericalPointWithDescription> > RegisteredFactory("PersistentCollection<NumericalPointWithDescription>");

      /* Default constructor */
      NumericalPointWithDescription::NumericalPointWithDescription()
	: NumericalPoint(new NumericalPointImplementationWithDescription, Derived() )
      {
        // Nothing to do
      }

      /* Constructor with size */
      NumericalPointWithDescription::NumericalPointWithDescription(const UnsignedLong size,
								   const NumericalScalar value)
	: NumericalPoint(new NumericalPointImplementationWithDescription(size, value), Derived() )
      {
        // Nothing to do
      }

      /* Constructor from implementation */
      NumericalPointWithDescription::NumericalPointWithDescription(const NumericalPointImplementationWithDescription & implementation)
	: NumericalPoint(implementation.clone(), Derived() )
      {
	// Nothing to do
      }

      /* Constructor from NumericalPoint  */
      NumericalPointWithDescription::NumericalPointWithDescription(const NumericalPoint & point)
	: NumericalPoint(new NumericalPointImplementationWithDescription(point.getImplementation()), Derived() )
      {
	// Nothing to do
      }



      /* String converter */
      String NumericalPointWithDescription::__repr__() const
      {
	return OSS() << "class=" << NumericalPointWithDescription::GetClassName()
		     << " name=" << getName()
		     << " dimension=" << getDimension()
		     << " implementation=" << getImplementation()->__repr__();
      }

      String NumericalPointWithDescription::__str__() const
      {
	return getImplementation()->__str__();
      }




      /* Description Accessor */
      void NumericalPointWithDescription::setDescription(const Description & description)
      {
	copyOnWrite();
	getImplementation()->setDescription(description);
      }


      /* Description Accessor */
      Description NumericalPointWithDescription::getDescription() const
      {
	return getImplementation()->getDescription();
      }


    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */
